
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

// BEGINFILE FullSizeEventHelper.js ------------------------------------------------------------------------->

function FullSizeEventHelper()
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.CurrentSlideNumber = -1;
	this.EventFullSizeCommand = new SfEvent(SfEventType.FullSizeCommand);
	this.EventFullSizeStatusChange = new SfEvent(SfEventType.FullSizeStatusChange);
	this.AutoRefreshSelected = true;

	this.GetMainHelper = function()
	{
		if (opener.closed)
		{
			this.Debug("opener is closed");
			return null;
		}
		
		if (!opener.MainHelper)
		{
			this.Debug("Could not find MainHelper in opener");
			return null;
		}
		var mainHelper = opener.MainHelper;
		return mainHelper;
	}
	
	this.GetPresentationStatus = function()
	{
		this.Debug("GetPresentationStatus called");
		if (!opener)
		{
			this.Debug("hmm.. no opener");
			return null;
		}
		
		if (opener.closed)
		{
			return null;
		}

		if (opener.MainHelper && opener.MainHelper.Presentation && opener.MainHelper.Presentation.Status)
		{
			var status = opener.MainHelper.Presentation.Status;
			this.Debug("PresentationStatus: " + status);
			return status;
		}
		else
		{
			this.Debug("Unable to find MainHelper or PresentationStatus");
			return null;
		}
		
	}
	
	this.NavigateToSlide = function()
	{
		this.Debug("NavigateToSlideCalled");
		var mainHelper = this.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			return;
		}

		var args = new CommandArgs(SfCommandType.NavigateToSlide);
		args.SlideNumber = this.CurrentSlideNumber;
		mainHelper.EventCommand.Post(args);
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeEventHelper: " + str);
	}
}

SfEventType.FullSizeCommand = "evFullSizeCommand";
SfEventType.FullSizeStatusChange = "evFullSizeStatusChange";

function SfFullSizeCommandType() {}
SfFullSizeCommandType.PreviousSlide = "PreviousSlide";
SfFullSizeCommandType.NextSlide = "NextSlide";
SfFullSizeCommandType.Refresh = "Refresh";
SfFullSizeCommandType.CheckBoxToggle = "CheckBoxToggle";

function SfFullSizeStatusChangeType() {}
SfFullSizeStatusChangeType.SlideChanged = "SlideChanged";


function FullSizeCommandArgs(fullSizeCommandType)
{
	this.CommandType = fullSizeCommandType;
	
	this.toString = function()
	{
		return "CommandType: " + this.CommandType;
	}
}

function FullSizeStatusChangeArgs(fullSizeStatusChangeType)
{
	this.StatusChangeType = fullSizeStatusChangeType;
	
	this.toString = function()
	{
		return "StatusChangeType: " + this.StatusChangeType;
	}
}

// ENDFILE FullSizeEventHelper.js --------------------------------------------------------------------------->

// BEGINFILE FullSizeAutoRefreshCheckBoxArea.js ------------------------------------------------------------->

FullSizeAutoRefreshCheckBoxArea.prototype = new AreaBase();
function FullSizeAutoRefreshCheckBoxArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);

	this.OnLoad = function()
	{
		this.Debug("FullSizeAutoRefreshCheckBoxAreaOnLoad called");
		this.AddEventHandlers();
		this.InitializeAutoRefreshState();
		var autoRefreshCheckBox = this.GetCheckBox();
		autoRefreshCheckBox.onclick = new Function("", this.Container + ".OnClick();");
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad called");
		this.RemoveEventHandlers();
	}

	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers called");
		this.FullSizeCommandEventHandler = new SfEventHandler("FullSizeAutoRefreshCheckBoxArea.FullSizeCommandEventHandler");
		this.FullSizeCommandEventHandler.MethodName = "OnFullSizeCommandEvent";
		this.FullSizeCommandEventHandler.Container = this.Container;
		FullSizeHelper.EventFullSizeCommand.AddHandler(this.FullSizeCommandEventHandler);
	}

	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandlers called");
		FullSizeHelper.EventFullSizeCommand.RemoveHandler(this.FullSizeCommandEventHandler);
	}

	this.OnFullSizeCommandEvent = function(args)
	{
		this.Debug("OnFullSizeCommandEvent called, args: " + args);
		switch (args.CommandType)
		{
			case SfFullSizeCommandType.CheckBoxToggle:
				this.ToggleCheckBox();
				break;
		}
	}
	
	this.ToggleCheckBox = function(args)
	{
		this.Debug("ToggleCheckBox called");
		var autoRefreshCheckBox = this.GetCheckBox();
		var currentState = autoRefreshCheckBox.checked;
		this.Debug("CurrentState: " + currentState);
		autoRefreshCheckBox.checked = !currentState;
		FullSizeHelper.AutoRefreshSelected = !currentState;
	}
	
	this.InitializeAutoRefreshState = function()
	{
		this.Debug("InitializeAutoRefreshState called");
		var autoRefreshCheckBox = this.GetCheckBox();
		var cookie = new SfCookie("AutoRefreshSelected");
		var value = cookie.Get();
		this.Debug("cookie Value: " + value);
		if (value && (value == "false"))
		{
			autoRefreshCheckBox.checked = false;
			FullSizeHelper.AutoRefreshSelected = false;
		}
		else
		{
			autoRefreshCheckBox.checked = true;
			FullSizeHelper.AutoRefreshSelected = true;
		}
	}
	
	this.OnClick = function()
	{
		this.Debug("OnClick called");
		var autoRefreshCheckBox = this.GetCheckBox();
		FullSizeHelper.AutoRefreshSelected = autoRefreshCheckBox.checked;
	}
	
	this.GetCheckBox = function()
	{
		var autoRefreshCheckBox = SfDOM.FindElementFromID(document, "FullSizeAutoRefreshCheckBoxInput");
		if (autoRefreshCheckBox == null)
		{
			this.Debug("GetCheckBox: not found");
		}
		return autoRefreshCheckBox;
	}

	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeAutoRefreshCheckBoxArea: " + str);
	}
}

// ENDFILE FullSizeAutoRefreshCheckBoxArea.js --------------------------------------------------------------->

// BEGINFILE FullSizeSlideArea.js --------------------------------------------------------------------------->

FullSizeSlideArea.prototype = new AreaBase();
function FullSizeSlideArea(container, containingWindow, ID)
{
	this.m_debugLevel = SfDebug.Verbose;
//	this.m_debugLevel = SfDebug.Information;

	this.InitializeArea(container, containingWindow, ID);
	this.IsInitialized = false;

	this.PreviousImageWidth = null;
	this.PreviousImageHeight = null;
	
	this.MainHelper = null;
	this.ImageUpdater = null;
	
	this.ImageCache = new ImageCache(this.Container + ".ImageCache");

	this.OnLoad = function()
	{
		this.Debug("FullSizeSlideAreaOnLoad called");
		this.InitializeImageUpdater();
		this.InitializeImage();
		this.AddEventHandlers();
	}

	this.OnUnLoad = function()
	{
		this.Debug("OnUnLoad called");
		this.RemoveEventHandlers();
	}
	
	this.AddEventHandlers = function()
	{
		this.Debug("AddEventHandlers called");
		this.FullSizeCommandEventHandler = new SfEventHandler("FullSizeSlideArea.FullSizeCommandEventHandler");
		this.FullSizeCommandEventHandler.MethodName = "OnFullSizeCommandEvent";
		this.FullSizeCommandEventHandler.Container = this.Container;
		FullSizeHelper.EventFullSizeCommand.AddHandler(this.FullSizeCommandEventHandler);
	}

	this.RemoveEventHandlers = function()
	{
		this.Debug("RemoveEventHandlers called");
		FullSizeHelper.EventFullSizeCommand.RemoveHandler(this.FullSizeCommandEventHandler);
	}

	this.OnFullSizeCommandEvent = function(args)
	{
		this.Debug("OnFullSizeCommandEvent called, args: " + args);
		switch (args.CommandType)
		{
			case SfFullSizeCommandType.PreviousSlide:
				this.PreviousSlide();
				break;
			case SfFullSizeCommandType.NextSlide:
				this.NextSlide();
				break;
			case SfFullSizeCommandType.Refresh:
				this.Refresh();
				break;
		}
	}
	
	this.InitializeImageUpdater = function()
	{
		this.Debug("InitializeImageUpdater called");
		var imageElement = this.GetCurrentImage();
		if (imageElement == null)
		{
			this.Debug("Could not find ImageElement in document");
			return;
		}
		
		var extraWidth = 0;
		var extraHeight = 0;

		var topOffset = this.GetTopOffset();
		if (topOffset == null)
		{
			topOffset = 0;
		}
		extraHeight = topOffset + extraHeight;
		
		this.ImageUpdater = new ImageUpdater(
			this.Container + ".ImageUpdater", 
			this.ContainingWindow,
			imageElement,
			extraWidth,
			extraHeight);
			
	}
	
	this.PreviousSlide = function()
	{
		this.Debug("PreviousSlide called");
		
		var currentSlideNumber = FullSizeHelper.CurrentSlideNumber;
		if (currentSlideNumber == -1)
		{
			this.Debug("don't know CurrentSlideNumber");
			return;
		}
		if (currentSlideNumber < 2)
		{
			this.Debug("Previous Slide should not be called here");
			return;
		}
		
		this.LoadSlideNumber(currentSlideNumber - 1);
	}
	
	this.NextSlide = function()
	{
		this.Debug("NextSlide called");
		
		var currentSlideNumber = FullSizeHelper.CurrentSlideNumber;
		if (currentSlideNumber == -1)
		{
			this.Debug("don't know CurrentSlideNumber");
			return;
		}
		
		this.LoadSlideNumber(currentSlideNumber + 1);
	}
	
	this.Refresh = function()
	{
		this.Debug("Refresh called");

		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			return;
		}

		var image = mainHelper.CurrentFullSizeImage;
		var slideNumber = mainHelper.CurrentSlideNumber;
		if (image == null)
		{
			this.Debug("No image in Viewer");
			return;
		}
		
		this.Debug("image: " + image, " slideNumber: " + slideNumber);
		this.UpdateImage(image, slideNumber);
	}

	this.InitializeImage = function()
	{
		this.Debug("InitializeImage called");
		
		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			return;
		}
		
		var slideNumber = mainHelper.CurrentSlideNumber;
		if (!slideNumber)
		{
			this.Debug("CurrentSlideNumber not present");
			return;
		}
		this.Debug("slideNumber: " + slideNumber);
		
		var imageSrc = mainHelper.CurrentFullSizeImage;
		if (!imageSrc)
		{
			this.Debug("No image selected yet");
			return;
		}
		this.Debug("imageSrc: " + imageSrc);
		
		this.ChangeImage(imageSrc, slideNumber);
		
		var status = FullSizeHelper.GetPresentationStatus();
		this.Debug("status: " + status);	
		var image = this.GetCurrentImage();
		if (status == PresentationStatus.CaptureInProgress)
		{
			image.alt = '';
			image.title = '';
			image.onclick = '';
			Util.SetCursor(image, CursorType.Default);
		}
		else
		{
			image.alt = this.PlayFromThisSlideText;
			image.title = this.PlayFromThisSlideText;
			image.onclick = new Function("", "FullSizeHelper.NavigateToSlide();");
			Util.SetCursor(image, CursorType.Hand);
		}
		
		FullSizeHelper.CurrentSlideNumber = mainHelper.CurrentSlideNumber;
		this.IsInitialized = true;
	}
	
	this.ChangeImage = function(imageSrc, slideNumber)
	{
		this.Debug("ChangeImage: imageSrc = " + imageSrc + ", slideNumber: " + slideNumber);
		this.ImageUpdater.ChangeImage(imageSrc);
		
		var mainHelper = FullSizeHelper.GetMainHelper();
		if (!mainHelper)
		{
			this.Debug("could not find mainhelper");
			return;
		}
		
		// cache the next image for non-live presentations.
		if ((mainHelper.Presentation.Status!=PresentationStatus.CaptureInProgress) && 
			(slideNumber<mainHelper.Presentation.SlideTimings.length))
		{
			var nextImageName = mainHelper.GetFullSizeImageName(slideNumber + 1);
			var nextImageUrl = mainHelper.Presentation.ImageBaseUrl + "/" + nextImageName;
			this.Debug("Putting " + nextImageUrl + " in cache");
			this.ImageCache.AddImage(nextImageUrl, true);
		}
	}
	
	this.GetTopOffset = function()
	{
		var elem = this.GetDiv();
		if (elem == null)
		{
			return null;
		}
		var top = elem.style.top;
		if (!top)
		{
			this.Debug("could not find top");
			return null;
		}
		try
		{
			top = this.ParsePx(top);
		}
		catch(ex)
		{
			return null;
		}
		return top;
	}
	
	this.LoadSlideNumber = function(slideNumber)
	{
		this.Debug("LoadSlideNumber: " + slideNumber + " called");

		var mainHelper = FullSizeHelper.GetMainHelper();
		if (mainHelper == null)
		{
			this.Debug("Null MainHelper");
			return;
		}
		
		var slideTiming = mainHelper.Presentation.SlideTimings[slideNumber-1];
		var fullSizeImageName = null;
		if (slideTiming.FullSize.Image)
		{
			fullSizeImageName = slideTiming.FullSize.Image;
		}
		else if (slideTiming.Normal.Image)
		{
			fullSizeImageName = slideTiming.Normal.Image;
		}
		else
		{
			SfDebug.DPF(SfDebug.ErrMsgCritical, "could not find normal or full size image for slide: " + slideNumber);
			return;
		}
		
		var toLoad = mainHelper.Presentation.ImageBaseUrl + "/" + fullSizeImageName;
		this.UpdateImage(toLoad, slideNumber);
	}
	
	this.UpdateImage = function(image, slideNumber)
	{
		this.Debug("UpdateImage called, image: " + image + ", slideNumber: " + slideNumber);
		if (this.IsInitialized == false)
		{
			this.Debug("Not initialized, initializing");
			this.InitializeImage();
		}
		this.ChangeImage(image, slideNumber);
		FullSizeHelper.CurrentSlideNumber = slideNumber;
		
		FullSizeHelper.EventFullSizeStatusChange.Post(new FullSizeStatusChangeArgs(SfFullSizeStatusChangeType.SlideChanged));
	}
	
	this.UpdateIfNeeded = function(image, slideNumber)
	{
		this.Debug("UpdateIfNeeded called, image: " + image + ", slideNumber: " + slideNumber);
		
		if (!FullSizeHelper.AutoRefreshSelected)
		{
			this.Debug("AutoRefresh not selected");
			return;
		}
		
		if (this.IsInitialized == false)
		{
			this.Debug("Not initialized, initializing");
			this.InitializeImage();
		}
		this.ChangeImage(image, slideNumber);
		FullSizeHelper.CurrentSlideNumber = slideNumber;
		
		FullSizeHelper.EventFullSizeStatusChange.Post(new FullSizeStatusChangeArgs(SfFullSizeStatusChangeType.SlideChanged));
	}
	
	this.GetCurrentImage = function()
	{
		var image = SfDOM.FindElementFromName(document, "bigimage");
		return image;
	}
	
	this.Debug = function(str)
	{
		SfDebug.DPF(this.m_debugLevel, "FullSizeSlideArea: " + str);
	}
}

// ENDFILE FullSizeSlideArea.js ----------------------------------------------------------------------------->